/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.sfp;

import com.ibm.hsc.auiml.databeans.sfp.ConnectionMonitorManager;
import com.ibm.hsc.auiml.databeans.sfp.SFPException;
import com.ibm.hsc.auiml.databeans.sfp.SFPSettingsBean;
import com.ibm.hsc.auiml.databeans.sfp.SFPSettingsData;
import com.ibm.hsc.auiml.databeans.sfp.data.CECStateInformation;
import com.ibm.hsc.auiml.databeans.sfp.data.SFPSettingsInformation;
import com.ibm.hsc.ccfw.mom.PICec;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.HSCPanelTasklet;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;

public class SFPSettingsTasklet
extends HSCPanelTasklet {
    private static final String TRACE_MASKD = "JSFPSETD";
    private static final String TRACE_MASKF = "JSFPSETF";
    private static final String TRACE_MASKT = "JSFPSETT";
    private static final ClassLogInfo _logInfo = new ClassLogInfo(-88, 119, "ConnectionMonitoring");
    private static final short ERRID_0001 = 1;
    private static final short ERRID_0002 = 2;
    private static final String ENABLED_LABEL = HSCResourceBundleUtil.getMessage("SFPResourceBundle", "ENABLED_LBL", "Enabled");
    private static final String DISABLED_LABEL = HSCResourceBundleUtil.getMessage("SFPResourceBundle", "DISABLED_LBL", "Disabled");
    private static final String UNKNOWN_LABEL = HSCResourceBundleUtil.getMessage("SFPResourceBundle", "UNKNOWN_LBL", "Unknown");
    private static final Object SESSION_CREATION_LOCK = new Object();
    private static boolean _retrying = false;
    final String SETTINGS_BEAN = "Partition Surveillance Settings";
    private static final String persistKey = (class$com$ibm$hsc$auiml$databeans$sfp$SFPSettingsTasklet == null ? (class$com$ibm$hsc$auiml$databeans$sfp$SFPSettingsTasklet = SFPSettingsTasklet.class$("com.ibm.hsc.auiml.databeans.sfp.SFPSettingsTasklet")) : class$com$ibm$hsc$auiml$databeans$sfp$SFPSettingsTasklet).getName();
    private SFPSettingsInformation settings = new SFPSettingsInformation();
    private PanelHandler resultsPanelHandler;
    private PanelHandler currentPanel = this.resultsPanelHandler = new PanelHandler(){

        public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
            if (1 <= Trace.LEVEL) {
                Trace.trace(SFPSettingsTasklet.TRACE_MASKT, "-> SFPSettingsTasklet.resultsPanelHandler.service()");
            }
            if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
                if (3 <= Trace.LEVEL) {
                    Trace.trace(SFPSettingsTasklet.TRACE_MASKD, "dispose or cancel specified");
                }
                panelTaskletResponse.terminate();
            } else {
                TaskActionEvent taskActionEvent = (TaskActionEvent)panelTaskletRequest.getData("event");
                if (taskActionEvent.getElementName().equals("Cancel")) {
                    if (3 <= Trace.LEVEL) {
                        Trace.trace(SFPSettingsTasklet.TRACE_MASKD, "event from panel was Cancel");
                    }
                    panelTaskletResponse.terminate();
                } else {
                    String string;
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(SFPSettingsTasklet.TRACE_MASKF, "event from panel was " + taskActionEvent.getElementName());
                    }
                    if ((string = (String)panelTaskletRequest.getData("action")).equals("errorMessage")) {
                        String string2 = (String)panelTaskletRequest.getData("msgkey");
                        SFPSettingsTasklet.this.showErrorMessageBox(string2);
                        panelTaskletResponse.noAction();
                        return;
                    }
                    SFPSettingsInformation sFPSettingsInformation = (SFPSettingsInformation)panelTaskletRequest.getData("settings");
                    try {
                        SFPSettingsTasklet.setConnectionValues(sFPSettingsInformation);
                    }
                    catch (SFPException sFPException) {
                        if (2 <= Trace.LEVEL) {
                            Trace.trace(SFPSettingsTasklet.TRACE_MASKF, "Exception saving Surveillance settings " + sFPException);
                        }
                        Object[] objectArray = new Object[]{sFPException.toString()};
                        SFPSettingsTasklet.this.showErrorMessageBox("0150", objectArray);
                        panelTaskletResponse.noAction();
                        return;
                    }
                    panelTaskletResponse.terminate();
                }
            }
            if (1 <= Trace.LEVEL) {
                Trace.trace(SFPSettingsTasklet.TRACE_MASKT, "<- SFPSettingsTasklet.resultsPanelHandler.service()");
            }
        }
    };
    static /* synthetic */ Class class$com$ibm$hsc$auiml$databeans$sfp$SFPSettingsTasklet;
    static /* synthetic */ Class class$com$ibm$hsc$ccfw$mom$PICec;

    public SFPSettingsTasklet() throws Throwable {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SFPSettingsTasklet.SFPSettings()");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SFPSettingsTasklet.SFPSettings()");
        }
    }

    public static synchronized SFPSettingsInformation getConnectionValues() throws SFPException {
        SFPSettingsInformation sFPSettingsInformation = new SFPSettingsInformation();
        int n = 0;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SFPSettingsTasklet.getConnectionValues()");
        }
        try {
            int n2;
            SFPSettingsData sFPSettingsData = new SFPSettingsData();
            SFPSettingsData sFPSettingsData2 = sFPSettingsData.getConnectionData();
            if (sFPSettingsData2 != null) {
                sFPSettingsInformation.connected = sFPSettingsData2.settings.getConnectedTimer();
                sFPSettingsInformation.disconnected = sFPSettingsData2.settings.getDisconnectedTimer();
                sFPSettingsInformation.interval = sFPSettingsData2.settings.getIntervalTimer();
                n = sFPSettingsData2.settings.getCecStateInformation().length;
            }
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "Number of saved CECs was " + n);
            }
            Vector vector = null;
            try {
                vector = SFPSettingsTasklet.getTargets();
            }
            catch (SFPException sFPException) {
                new AusMicrocodeLog(_logInfo, 2, sFPException).writeEntry(null);
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKT, "<- SFPSettingsTasklet.getConnectionValues() getTargets() failed with exception " + sFPException);
                }
                throw sFPException;
            }
            int n3 = n2 = vector == null ? 0 : vector.size();
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "SFPSettingsTasklet.getConnectionValues() number of cecs is " + n2);
            }
            sFPSettingsInformation.stateInformation = new CECStateInformation[n2];
            for (int i = 0; i < n2; ++i) {
                CECStateInformation cECStateInformation = new CECStateInformation();
                String[] stringArray = (String[])vector.get(i);
                cECStateInformation.machineName = stringArray[0];
                cECStateInformation.machineModelType = stringArray[1];
                cECStateInformation.machineSerial = stringArray[2];
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKT, "stateInformation():  \n  Name=" + cECStateInformation.machineName + "\n  ModelType=" + cECStateInformation.machineModelType + "\n  SN=" + cECStateInformation.machineSerial);
                }
                boolean bl = true;
                for (int j = 0; j < n; ++j) {
                    if (!cECStateInformation.getMachineId().equals(sFPSettingsData2.settings.stateInformation[j].getMachineId())) continue;
                    cECStateInformation.surveillanceState = sFPSettingsData2.settings.stateInformation[j].surveillanceState;
                    bl = false;
                    if (2 <= Trace.LEVEL) {
                        // empty if block
                    }
                    Trace.trace(TRACE_MASKF, "State for " + cECStateInformation.machineName + " = " + cECStateInformation.surveillanceState);
                }
                if (bl) {
                    if (2 <= Trace.LEVEL) {
                        // empty if block
                    }
                    Trace.trace(TRACE_MASKF, "State for " + cECStateInformation.machineName + " set to " + DISABLED_LABEL);
                    cECStateInformation.surveillanceState = ENABLED_LABEL;
                }
                sFPSettingsInformation.stateInformation[i] = cECStateInformation;
            }
        }
        catch (SFPException sFPException) {
            if (2 <= Trace.LEVEL) {
                // empty if block
            }
            Trace.trace(TRACE_MASKF, "Error doing SFPSettings.getConnectionData() " + sFPException);
            new AusMicrocodeLog(_logInfo, 1, sFPException).writeEntry(null);
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<-SFPSettingsTasklet.getConnectionValues() with error reading persistence data.");
            }
            throw sFPException;
        }
        catch (Exception exception) {
            if (2 <= Trace.LEVEL) {
                // empty if block
            }
            Trace.trace(TRACE_MASKF, "Exception in getConnectionValues()  " + exception);
            new AusMicrocodeLog(_logInfo, 1, exception).writeEntry(null);
            throw new SFPException("0149", exception);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SFPSettingsTasklet.getConnectionValues()");
        }
        return sFPSettingsInformation;
    }

    private static void setConnectionValues(SFPSettingsInformation sFPSettingsInformation) throws SFPException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SFPSettingsTasklet.setConnectionValues()");
        }
        try {
            SFPSettingsData sFPSettingsData = new SFPSettingsData();
            sFPSettingsData.setConnectionData(sFPSettingsInformation);
            Trace.trace(TRACE_MASKF, "Notifying listeners of timer changes");
            ConnectionMonitorManager.getConnectionMonitorManager().notifyTimersChanged(sFPSettingsInformation.getConnectedTimer(), sFPSettingsInformation.getDisconnectedTimer(), sFPSettingsInformation.getIntervalTimer());
        }
        catch (SFPException sFPException) {
            if (2 <= Trace.LEVEL) {
                // empty if block
            }
            Trace.trace(TRACE_MASKF, "Exception doing Persistence.write " + sFPException);
            new AusMicrocodeLog(_logInfo, 1, sFPException).writeEntry(null);
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<-SFPSettingsTasklet.setConnectionValues() with Persistence exception");
            }
            throw sFPException;
        }
        catch (Exception exception) {
            if (2 <= Trace.LEVEL) {
                // empty if block
            }
            Trace.trace(TRACE_MASKF, "Exception doing Persistence.write " + exception);
            new AusMicrocodeLog(_logInfo, 1, exception).writeEntry(null);
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<-SFPSettingsTasklet.setConnectionValues() with Persistence exception");
            }
            throw new SFPException("0149", exception);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SFPSettingsTasklet.setConnectionValues()");
        }
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        if (panelTaskletRequest.isInitialRequest()) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "SFPSettingsTasklet.service() (initial request) ptp= '" + this.presentationTaskParms + "'");
                Trace.trace(TRACE_MASKT, "SFPSettingsTasklet.service() (initial request) req-data= '" + panelTaskletRequest.getDataMap() + "'");
            }
            SFPSettingsInformation sFPSettingsInformation = null;
            try {
                sFPSettingsInformation = SFPSettingsTasklet.getConnectionValues();
            }
            catch (SFPException sFPException) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Exception getting surveillance information: " + sFPException);
                }
                Object[] objectArray = new Object[]{sFPException.toString()};
                this.showErrorMessageBox("0149", objectArray);
                panelTaskletResponse.noAction();
                return;
            }
            this.currentPanel = this.resultsPanelHandler;
            SFPSettingsBean sFPSettingsBean = new SFPSettingsBean(sFPSettingsInformation);
            sFPSettingsBean.setBeanName("Partition Surveillance Settings");
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Launching SFPSettings Bean");
            }
            panelTaskletResponse.replace("com.ibm.hsc.auiml.databeans.sfp.SFPSurveillance", "SFPLanSurveillance", (PanelBean)sFPSettingsBean);
        } else {
            this.currentPanel.service(panelTaskletRequest, panelTaskletResponse);
        }
    }

    public static Vector getTargets() throws SFPException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SFPSettingsTasklet.getTargets()");
        }
        Vector<String[]> vector = new Vector<String[]>();
        int n = 0;
        try {
            CommonSystem.getCommonSystem().setLocation(1);
            CommonSystem.getCommonSystem().setSystemUserContext(new UserContext(null, null, 3, null, Locale.getDefault()));
            ManagedObjectManager managedObjectManager = ManagedObjectManager.getManagedObjectManager();
            Set set = managedObjectManager.getInventory(new ClassId(class$com$ibm$hsc$ccfw$mom$PICec == null ? (class$com$ibm$hsc$ccfw$mom$PICec = SFPSettingsTasklet.class$("com.ibm.hsc.ccfw.mom.PICec")) : class$com$ibm$hsc$ccfw$mom$PICec));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                PICec pICec = (PICec)iterator.next();
                String[] stringArray = new String[]{pICec.getUserDefinedName(), pICec.getMachineType() + "-" + pICec.getModel(), pICec.getSerialNumber()};
                vector.add(stringArray);
                if (3 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "-- CEC found, MTMS: " + stringArray[0] + " UserName: " + stringArray[1]);
                }
                ++n;
            }
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "-- total objects retrieved is: " + n);
            }
        }
        catch (Exception exception) {
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Exception getting CEC Information: " + exception);
            }
            throw new SFPException(exception.toString());
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SFPSettingsTasklet.getTargets()");
        }
        return vector;
    }

    public void logException(Throwable throwable) {
    }

    public void init() throws TaskletException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->SFPSettingsTasklet.init() redirect data = '" + this.getRedirectData() + "'");
        }
        super.init();
    }

    private void showErrorMessageBox(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-> showErrorMessageBox(" + string + ")");
        }
        this.showErrorMessageBox(string, null);
    }

    private void showErrorMessageBox(String string, Object[] objectArray) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-> showErrorMessageBox(" + string + "," + objectArray + ")");
        }
        this.showErrorMessageBox(new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "SFP_MESSAGE_ERROR_TITLE"), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "Z", "com.ibm.hsc.common.bundles.SFPResourceBundleMessages", string, objectArray));
    }

    private void showErrorMessageBox(LocalizableText localizableText, HSCLocalizableMsg hSCLocalizableMsg) {
        block3: {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<-> showErrorMessageBox(" + localizableText + "," + (Object)((Object)hSCLocalizableMsg) + ")");
            }
            try {
                this.showMessageBox(true, localizableText, hSCLocalizableMsg);
            }
            catch (TaskletException taskletException) {
                if (Trace.LEVEL < 2) break block3;
                Trace.trace(TRACE_MASKF, "TaskletException while showing error message box: " + (Object)((Object)taskletException));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static interface PanelHandler {
        public void service(PanelTaskletRequest var1, PanelTaskletResponse var2) throws TaskletException;
    }
}

